function test_suite = testMldivide %#ok<STOUT>
initTestSuite;

function testZeroDividedByReal %#ok<*DEFNU>
x = polysym(0);
y = polysym(rand);
z = y\x;
assertTrue(z.Value=='0');

function testZeroDividedByChar
x = polysym(0);
y = polysym('y');
z = y\x;
assertTrue(z.Value=='0');

function testZeroDividedByZero
x = polysym(0);
f = @() 0\x;
assertExceptionThrown(f,'polysym:mldivide:DivideByZero')

function testCharDividedByZero
x = polysym('x');
f = @() 0\x;
assertExceptionThrown(f,'polysym:mldivide:DivideByZero')

function testCharDividedByInteger
x = polysym('x');
z = 5\x;
assertEqual(z.Value,'x/5');

function testCharDividedByReal
x = polysym('x');
y = polysym(pi);
z = y\x;
assertEqual(z.Value,['x/',y.Value]);

function testRealDividedByChar
x = polysym(pi);
y = polysym('y');
z = y\x;
assertEqual(z.Value,[x.Value,'/y']);

function testScalarDividedByVector
x = polysym('x');
f = @() (1:3)\x;
assertExceptionThrown(f,'polysym:mldivide:NotScalar')

function testVectorDividedByVector
x = polysym({'x','y'});
y = polysym({'u','w'});
f = @() y\x;
assertExceptionThrown(f,'polysym:mldivide:NotScalar')

function testDivDiv
% NOTE: This result is undesirable.
x = polysym('x');
y = polysym('4/y');
z = y\x;
assertEqual(z.Value,'x/4/y');
